/*
 * LCD_avrlib.c
 * Created: 19.01.2013 16:40:33
 *  Author: shelf05@mail.ru
 */ 

#include <avr/io.h>
#include <global.h>
#include <lcd.h>
#include <avr/interrupt.h>

// ""
#define btnBalance 0x01
#define CHECK_INPUT(x,y) (x & (y)) //   y   x

// 
unsigned int countL, countH;
char level = -1; // 
char s[8];
char sBalance[] = "BALANCE"; 
char sign;
int idx = 0;
int minus = 0;
unsigned long ind_0, c;
unsigned int cd;
long d1, d2, d3, d4, d5, d6, d7, d8, d9, d10;
int tmp_mean; //  (     )
int d_izm, d; //  (  )
int n200; //  ( 100 )
unsigned long overflowC;
unsigned long count; //100  (     100     )
unsigned long count200; //  100 
unsigned long tmp_count; //
char firstStart= '1'; 

ISR(TIMER1_OVF_vect)
{
	overflowC++;
}

ISR(TIMER1_CAPT_vect)
{
	countL = ICR1L;
	countH=ICR1H;
	TCNT1H=0x00;
	TCNT1L=0x00;
	count200 = countH * 256 + countL + overflowC * 0x10000 + 40;
	overflowC=0;
	if (n200<100)
	{
		tmp_count+=count200;
		n200++;
	}
	else
	{ // 100    ICP 
		count=tmp_count/2;
		n200=0;
		tmp_count=0;
	}
}

void level_d()
{
        uint8_t x, xd;
        if (d>0 && d<=16) xd=d;
        else if (d>16 || d<-16) xd=16;
        else if (d<0 && d>=-16) xd=d*(-1);
        else xd=0;
        lcdClear();
		if (d>0)
        {
                for (x=0; x<xd; x++)
                {
						lcdGotoXY(x,0);
						lcdDataWrite(level);
                }
        }
        else if (d<0)
        {
                for (x=0; x<xd; x++)
                {
						lcdGotoXY(15-x,0);
						lcdDataWrite(level);
                }
        }
}

int main(void)
{
	// Crystal Oscilator division factor: 1
	CLKPR=(1<<CLKPCE);
	CLKPR=(0<<CLKPCE) | (0<<CLKPS3) | (0<<CLKPS2) | (0<<CLKPS1) | (0<<CLKPS0);
	
//PORTC=0x01; //PINC0 -  "BALANCE"
DDRC=0x00; //
PORTC=(0<<PORTC6) | (0<<PORTC5) | (0<<PORTC4) | (0<<PORTC3) | (0<<PORTC2) | (0<<PORTC1) | (1<<PORTC0);

DDRD=0x00; 
PORTD=(0<<PORTD7) | (0<<PORTD6) | (0<<PORTD5) | (0<<PORTD4) | (0<<PORTD3) | (0<<PORTD2) | (0<<PORTD1) | (0<<PORTD0);

	
		// Timer/Counter 1 initialization
	// Clock source: System Clock
	// Clock value: 12000,000 kHz
	// Mode: Normal top=FFFFh
	// OC1A output: Discon.
	// OC1B output: Discon.
	// Noise Canceler: On
	// Input Capture on Falling Edge
	// Timer 1 Overflow Interrupt: On
	// Input Capture Interrupt: On
	// Compare A Match Interrupt: Off
	// Compare B Match Interrupt: Off
	TCCR1A=0x00;
	TCCR1B=0x81;
	TCNT1H=0x00;
	TCNT1L=0x00;
	ICR1H=0x00;
	ICR1L=0x00;
	OCR1AH=0x00;
	OCR1AL=0x00;
	OCR1BH=0x00;
	OCR1BL=0x00;
	
	// Timer/Counter 1 Interrupt(s) initialization
	TIMSK1=0x21;

ind_0 = 0;	
lcdInit();
n200=0;
tmp_count=0;
tmp_mean=0;
cd=1;
sei();
	
    while(1)
    {
		_delay_ms(20);
		if (firstStart == '1')
		{
			_delay_ms(250);
			lcdClear();
			lcdPrintData(sBalance, 7);
			ind_0 = count;
			firstStart = '0';
			_delay_ms(999);
		}
		//  
        if (!(CHECK_INPUT(PINC,btnBalance))) 
		{
			lcdClear();
			lcdPrintData(sBalance, 7);
			ind_0 = count;
			_delay_ms(999);
		}
				
		if (n200 != 0)
        {
          //c=100; //
		  c=count; //     
		  d_izm=ind_0-c; //  
          if (cd<11) 
          {
			 switch (cd)
			 {
			 case 1 : d1=d_izm;	break;
			 case 2 : d2=d_izm;	break;
			 case 3 : d3=d_izm;	break;
			 case 4 : d4=d_izm;	break;
			 case 5 : d5=d_izm;	break;
			 case 6 : d6=d_izm;	break;
			 case 7 : d7=d_izm;	break;
			 case 8 : d8=d_izm;	break;
			 case 9 : d9=d_izm;	break;
			 case 10 : d10=d_izm; break;
			 default: break;
			 }
             cd++;
          }
          else
          {
			d_izm=(2*(d1+d2+d3+d4+d5+d6+d7+d8+d9+d10)+10)/20;
            if (d_izm != tmp_mean)
               {
			   if (d_izm > tmp_mean) {d_izm--;}
                  else if (d_izm < tmp_mean) {d_izm++;}
			   }				  
            tmp_mean=d_izm; 
            d=d_izm;
            level_d(); //    		
			//  -    
			lcdGotoXY(0,1);
			//    
			idx = 0; 
			for (int i = 0; i<7; i++) s[i] = 0;  			 
			if (d_izm<0)
			{
				d_izm *= -1;
				minus = 1;
			}
			else minus = 0;
			if (minus) lcdDataWrite('-'); 
			do 
			{
				switch (d_izm%10)
				{
					case 0: sign = '0'; break;
					case 1: sign = '1'; break;
					case 2: sign = '2'; break;
					case 3: sign = '3'; break;
					case 4: sign = '4'; break;
					case 5: sign = '5'; break;
					case 6: sign = '6'; break;
					case 7: sign = '7'; break;
					case 8: sign = '8'; break;
					case 9: sign = '9'; break;
				}
				d_izm /= 10;
				s[idx++] = sign;
			} while (d_izm != 0);
			for (int i = idx; i >= 0; --i) 
			{
				if (s[i]!=0) lcdDataWrite(s[i]); 	
			}			
            cd=1;
          }
        }
    }
}